<?php $title = 'Buscar - ' . $config['app_name']; include __DIR__ . '/../partials/head.php'; ?>
<?php include __DIR__ . '/../partials/header.php'; ?>

<main class="container page">
  <h1>Buscar</h1>
  <form method="get" action="/search" class="searchbar">
    <input class="input" name="q" value="<?= h($q) ?>" placeholder="Buscar productos...">
    <button class="btn" type="submit">Buscar</button>
  </form>

  <?php if ($q === ''): ?>
    <div class="empty">
      <div class="empty-title">Escribí algo para buscar</div>
    </div>
  <?php elseif (!$products): ?>
    <div class="empty">
      <div class="empty-title">No hay resultados</div>
      <div class="empty-sub">Probá con otra palabra.</div>
    </div>
  <?php else: ?>
    <div class="grid">
      <?php foreach ($products as $p): 
        $img = $db->prepare("SELECT url FROM product_images WHERE product_id=? ORDER BY sort_order ASC LIMIT 1");
        $img->execute([$p['id']]);
        $img = $img->fetchColumn();
      ?>
      <a class="card" href="/p/<?= h($p['slug']) ?>">
        <div class="card-img" style="background-image:url('<?= h($img ?: '/public/assets/placeholder.jpg') ?>')"></div>
        <div class="card-body">
          <div class="card-title"><?= h($p['name']) ?></div>
          <div class="card-price"><?= h(money_ars($p['price'])) ?></div>
        </div>
      </a>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</main>

<?php include __DIR__ . '/../partials/footer.php'; ?>
