<?php $title = $p['name'] . ' - ' . $config['app_name']; include __DIR__ . '/../partials/head.php'; ?>
<?php include __DIR__ . '/../partials/header.php'; ?>

<main class="container page">
  <div class="breadcrumb">
    <?php if (!empty($p['category_slug'])): ?>
      <a class="link" href="/c/<?= h($p['category_slug']) ?>"><?= h($p['category_name']) ?></a>
      <span> / </span>
    <?php endif; ?>
    <span><?= h($p['name']) ?></span>
  </div>

  <div class="pdp">
    <div class="gallery">
      <?php $main = $imgs[0]['url'] ?? '/public/assets/placeholder.jpg'; ?>
      <div class="gallery-main" id="mainImg" style="background-image:url('<?= h($main) ?>')"></div>
      <div class="thumbs">
        <?php foreach ($imgs as $im): ?>
          <button class="thumb" type="button" data-img="<?= h($im['url']) ?>" style="background-image:url('<?= h($im['url']) ?>')"></button>
        <?php endforeach; ?>
      </div>
    </div>

    <div class="buy">
      <h1><?= h($p['name']) ?></h1>
      <div class="price"><?= h(money_ars($p['price'])) ?> <span class="muted">ARS</span></div>
      <div class="desc"><?= nl2br(h($p['description'])) ?></div>

      <form class="buy-form" action="/cart/add" method="post">
        <input type="hidden" name="_csrf" value="<?= h(csrf_token($config)) ?>">
        <input type="hidden" name="product_id" value="<?= (int)$p['id'] ?>">

        <?php if ($vars): ?>
          <label class="label">Variante</label>
          <select class="input" name="variant_id" required>
            <?php foreach ($vars as $v): 
              $label = trim(($v['color'] ?? '') . ' ' . ($v['size'] ?? ''));
              if ($label === '') $label = $v['sku'] ?: ('Variante ' . $v['id']);
              $stock = (int)$v['stock'];
              $p2 = $v['price'] !== null ? (float)$v['price'] : null;
            ?>
              <option value="<?= (int)$v['id'] ?>" <?= $stock<=0?'disabled':'' ?>>
                <?= h($label) ?><?= $p2!==null ? ' - ' . money_ars($p2) : '' ?><?= $stock<=0 ? ' (sin stock)' : '' ?>
              </option>
            <?php endforeach; ?>
          </select>
        <?php endif; ?>

        <label class="label">Cantidad</label>
        <input class="input" type="number" min="1" name="qty" value="1">

        <button class="btn btn-wide" type="submit">Agregar al carrito</button>
        <div class="note">Pago: Transferencia / QR (se coordina tras confirmar el pedido).</div>
      </form>
    </div>
  </div>
</main>

<?php include __DIR__ . '/../partials/footer.php'; ?>
