<?php $title = $cat['name'] . ' - ' . $config['app_name']; include __DIR__ . '/../partials/head.php'; ?>
<?php include __DIR__ . '/../partials/header.php'; ?>

<main class="container page">
  <div class="breadcrumb"><?= h($cat['name']) ?></div>

  <div class="plp">
    <aside class="filters">
      <form method="get">
        <div class="filter-block">
          <div class="filter-title">Buscar</div>
          <input class="input" name="q" value="<?= h($q) ?>" placeholder="campera, jean..." />
        </div>

        <div class="filter-block">
          <div class="filter-title">Talle</div>
          <?php foreach ($sizes as $s): ?>
            <label class="check">
              <input type="radio" name="size" value="<?= h($s) ?>" <?= ($f_size===$s?'checked':'') ?> />
              <span><?= h($s) ?></span>
            </label>
          <?php endforeach; ?>
          <label class="check"><input type="radio" name="size" value="" <?= ($f_size===''?'checked':'') ?> /><span>Todos</span></label>
        </div>

        <div class="filter-block">
          <div class="filter-title">Color</div>
          <?php foreach ($colors as $c): ?>
            <label class="check">
              <input type="radio" name="color" value="<?= h($c) ?>" <?= ($f_color===$c?'checked':'') ?> />
              <span><?= h($c) ?></span>
            </label>
          <?php endforeach; ?>
          <label class="check"><input type="radio" name="color" value="" <?= ($f_color===''?'checked':'') ?> /><span>Todos</span></label>
        </div>

        <div class="filter-block">
          <div class="filter-title">Ordenar</div>
          <select class="input" name="sort">
            <option value="relevance" <?= $sort==='relevance'?'selected':'' ?>>Relevancia</option>
            <option value="price_asc" <?= $sort==='price_asc'?'selected':'' ?>>Precio: menor</option>
            <option value="price_desc" <?= $sort==='price_desc'?'selected':'' ?>>Precio: mayor</option>
          </select>
        </div>

        <button class="btn" type="submit">Aplicar</button>
      </form>
    </aside>

    <section>
      <?php if (!$products): ?>
        <div class="empty">
          <div class="empty-title">No hay productos para estos filtros.</div>
          <div class="empty-sub">Probá limpiar filtros o importar catálogo desde la API.</div>
          <a class="btn" href="/admin/import">Importar</a>
        </div>
      <?php else: ?>
        <div class="grid">
          <?php foreach ($products as $p): 
            $img = $db->prepare("SELECT url FROM product_images WHERE product_id=? ORDER BY sort_order ASC LIMIT 1");
            $img->execute([$p['id']]);
            $img = $img->fetchColumn();
          ?>
          <a class="card" href="/p/<?= h($p['slug']) ?>">
            <div class="card-img" style="background-image:url('<?= h($img ?: '/public/assets/placeholder.jpg') ?>')"></div>
            <div class="card-body">
              <div class="card-title"><?= h($p['name']) ?></div>
              <div class="card-price"><?= h(money_ars($p['price'])) ?></div>
            </div>
          </a>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
    </section>
  </div>
</main>

<?php include __DIR__ . '/../partials/footer.php'; ?>
