<?php $title = 'Productos - ' . $config['app_name']; include __DIR__ . '/_head.php'; ?>
<?php include __DIR__ . '/_top.php'; ?>

<main class="container page">
  <div class="page-head">
    <h1>Productos</h1>
    <a class="btn" href="/admin/products/new">+ Nuevo</a>
  </div>

  <?php if ($ok = flash_get('ok')): ?>
    <div class="alert"><?= h($ok) ?></div>
  <?php endif; ?>

  <div class="table">
    <div class="tr th">
      <div>Producto</div><div>SKU/Ext</div><div>Precio</div><div>Categoría</div><div>Estado</div><div>Acción</div>
    </div>
    <?php foreach ($items as $p): ?>
      <div class="tr">
        <div>
          <div class="strong"><?= h($p['name']) ?></div>
          <div class="muted">/p/<?= h($p['slug']) ?></div>
        </div>
        <div class="muted"><?= h($p['external_id'] ?: '-') ?></div>
        <div><?= h(money_ars($p['price'])) ?></div>
        <div class="muted"><?= h($p['category_name'] ?: '-') ?></div>
        <div><?= $p['is_active'] ? '<span class="pill pill-ok">Activo</span>' : '<span class="pill">Inactivo</span>' ?></div>
        <div>
          <a class="link" href="/admin/products/edit/<?= (int)$p['id'] ?>">Editar</a>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</main>

<?php include __DIR__ . '/../partials/footer.php'; ?>
