<?php $title = 'Importar CSV - ' . $config['app_name']; include __DIR__ . '/_head.php'; ?>
<?php include __DIR__ . '/_top.php'; ?>

<main class="container page">
  <h1>Importar productos desde CSV</h1>

  <?php if ($ok = flash_get('ok')): ?>
    <div class="alert"><?= h($ok) ?></div>
  <?php endif; ?>
  <?php if ($err = flash_get('error')): ?>
    <div class="alert alert-error"><?= h($err) ?></div>
  <?php endif; ?>

  <div class="panel">
    <div class="panel-title">Subir archivo</div>
    <div class="muted">Soporta CSV con encabezados. Si tenés XLSX, exportalo a CSV primero.</div>

    <form method="post" action="/admin/import-file" enctype="multipart/form-data" class="row">
      <input type="hidden" name="_csrf" value="<?= h(csrf_token($config)) ?>">
      <input class="input" type="file" name="csv_file" accept=".csv" required>
      <button class="btn" type="submit">Importar</button>
    </form>

    <div class="note">
      Columnas aceptadas (usa cualquiera de estos nombres):<br>
      <b>sku</b>, <b>name</b>, <b>description</b>, <b>price</b>, <b>category/categories</b>, <b>images</b>, <b>color</b>, <b>sizes</b>, <b>stock</b>.<br>
      Imágenes: podés separar varias con <code>|</code> o coma.
    </div>
  </div>

  <div class="panel">
    <div class="panel-title">Ejemplo CSV</div>
<pre class="code">sku,name,price,category,images,color,sizes,stock,description
CAM-001,Campera Denim,7500,Mujer,"https://.../1.jpg|https://.../2.jpg",Azul,"S,M,L",12,"Denim premium..."
</pre>
  </div>
</main>

<?php include __DIR__ . '/../partials/footer.php'; ?>
