<?php $title = 'Importar API - ' . $config['app_name']; include __DIR__ . '/_head.php'; ?>
<?php include __DIR__ . '/_top.php'; ?>

<main class="container page">
  <h1>Importar productos desde API</h1>

  <?php if ($ok = flash_get('ok')): ?>
    <div class="alert"><?= h($ok) ?></div>
  <?php endif; ?>
  <?php if ($err = flash_get('error')): ?>
    <div class="alert alert-error"><?= h($err) ?></div>
  <?php endif; ?>

  <div class="panel">
    <div class="panel-title">URL de la API</div>
    <div class="muted">La API debe devolver JSON (array o {items:[...]}) con campos típicos: id, name/title, description, price, images, category, variants.</div>

    <form method="post" action="/admin/import" class="row">
      <input type="hidden" name="_csrf" value="<?= h(csrf_token($config)) ?>">
      <input class="input" name="api_url" value="<?= h($api_url) ?>" placeholder="https://api.tu-dominio.com/products">
      <button class="btn" type="submit">Importar / Actualizar</button>
    </form>

    <div class="note">
      Tip: si tu API necesita token, ponelo en <code>app/config.php</code> dentro de <code>products_api_headers</code>.
    </div>
  </div>

  <div class="panel">
    <div class="panel-title">Ejemplo de JSON esperado</div>
<pre class="code">[
  {
    "id": "CAM-001",
    "name": "Campera Denim",
    "description": "Denim premium...",
    "price": 7500,
    "category": "Mujer",
    "images": ["https://.../1.jpg","https://.../2.jpg"],
    "variants": [
      {"sku":"CAM-001-BLK-S","color":"Negro","size":"S","price":7500,"stock":12},
      {"sku":"CAM-001-BLK-M","color":"Negro","size":"M","price":7500,"stock":8}
    ]
  }
]</pre>
  </div>
</main>

<?php include __DIR__ . '/../partials/footer.php'; ?>
